package org.jeecg.modules.system.job;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.system.entity.*;
import org.jeecg.modules.system.mapper.SysDictItemMapper;
import org.jeecg.modules.system.mapper.SysPositionMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.service.IMxkUserinfoService;
import org.jeecg.modules.system.service.ISysDictItemService;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.service.ISysUserService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * @Description: Maxkey用户同步任务
 *
 * @author: liaogui
 * @date: 2026年01月14日
 */
@Slf4j
public class MaxkeyUserJob implements Job {
    @Autowired
    private IMxkUserinfoService mxkUserinfoService;

    @Autowired
    private ISysUserService sysUserService;

    @Autowired
    private SysUserDepartMapper sysUserDepartMapper;

    @Autowired
    private SysPositionMapper sysPositionMapper;

    @Autowired
    private ISysDictItemService sysDictItemService;

    @Autowired
    private SysDictItemMapper sysDictItemMapper;

    @Autowired
    private SysUserTenantMapper sysUserTenantMapper;

    private final static Integer TENANT_ID = 1002;

    private final static String PASSWORD = "cb362cfeefbf3d8d";

    private final static String SALT = "RCGTeGiH";

    private final static String ADMIN = "admin";




    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info("--------同步Maxkey用户信息 start--------");
        List<MxkUserinfo> mxkUserinfos = mxkUserinfoService.getBaseMapper()
                .selectList(new LambdaQueryWrapper<MxkUserinfo>()
                .notIn(MxkUserinfo::getUsername, List.of(ADMIN))
                );
        AtomicInteger successCount = new AtomicInteger();
        AtomicInteger failCount = new AtomicInteger();
        mxkUserinfos.forEach(mxkUserinfo -> {
            log.info("==============当前用户信息: mxkUserinfo{} ==============", mxkUserinfo);
            if (StringUtils.isNotBlank(mxkUserinfo.getNickname())) {
                try {
                    SysUser sysUser = new SysUser();
                    sysUser.setUsername(mxkUserinfo.getUsername());
                    sysUser.setRealname(mxkUserinfo.getNickname());
                    sysUser.setPassword(PASSWORD);
                    sysUser.setSalt(SALT);
                    sysUser.setEmail(mxkUserinfo.getEmail());
                    sysUser.setPhone(mxkUserinfo.getMobile());
                    sysUser.setLoginTenantId(TENANT_ID);
                    sysUser.setOrgCode(mxkUserinfo.getDepartmentid());
                    sysUser.setBelongDepIds(mxkUserinfo.getDepartmentid());
                    sysUser.setStatus(mxkUserinfo.getUserstate().equals("RESIDENT") ? 1 : 3 );
                    sysUser.setDelFlag(0);
                    sysUser.setActivitiSync(1);
                    sysUser.setWorkNo(mxkUserinfo.getEmployeenumber());
                    sysUser.setUserIdentity(1);
                    sysUser.setSort(1000);
                    sysUser.setCreateBy(ADMIN);
                    sysUser.setSex(mxkUserinfo.getGender() == 2 ? 1 : 2);
                    SysUser one = sysUserService.getOne(new LambdaQueryWrapper<SysUser>().eq(SysUser::getUsername, mxkUserinfo.getUsername()));
                    if (one != null ){
                        sysUser.setId(one.getId());
                        sysUser.setUpdateBy(ADMIN);
                    }
                    try {
                        if (StringUtils.isNotBlank(mxkUserinfo.getDepartmentid())) {
                            // 先删除原来的关联关系
                            sysUserDepartMapper.delete(new LambdaQueryWrapper<SysUserDepart>().eq(SysUserDepart::getUserId, sysUser.getId()));
                            sysUserDepartMapper.insert(new SysUserDepart(sysUser.getId(), mxkUserinfo.getDepartmentid()));
                        }
                    } catch (Exception e) {
                        log.error("当前已存在用户与部门的关联关系");
                    }
                    // 更新职务信息表
                    if (StringUtils.isNotBlank(mxkUserinfo.getJobtitle())) {
                        SysPosition sysPosition = sysPositionMapper.selectOne(
                                new LambdaQueryWrapper<SysPosition>()
                                        .eq(SysPosition::getName, mxkUserinfo.getJobtitle()));
                        if (sysPosition == null) {
                            sysPosition = new SysPosition();
                            sysPosition.setName(mxkUserinfo.getJobtitle());
                            Long count = sysPositionMapper.selectCount(new LambdaQueryWrapper<>());
                            sysPosition.setPostLevel(count.intValue() + 1);
                            sysPositionMapper.insertOrUpdate(sysPosition);
                        }
                        sysUser.setPositionType(String.valueOf(sysPosition.getPostLevel()));
                    }
                    // 更新用户对应租户ID
                    Long tenantCount = sysUserTenantMapper.selectCount(new LambdaQueryWrapper<SysUserTenant>()
                            .eq(SysUserTenant::getUserId, sysUser.getId()));
                    if (tenantCount == 0L) {
                        // 绑定租户
                        SysUserTenant sysUserTenant = new SysUserTenant();
                        sysUserTenant.setUserId(sysUser.getId());
                        sysUserTenant.setTenantId(TENANT_ID);
                        sysUserTenant.setStatus("1");
                        sysUserTenant.setCreateBy(ADMIN);
                        sysUserTenantMapper.insert(sysUserTenant);
                    }
                    sysUserService.saveOrUpdate(sysUser);

                    successCount.getAndIncrement();
                }catch (Exception e) {
                    log.error("同步用户信息失败：{}", e.getMessage());
                    failCount.getAndIncrement();
                }
            } else {
                log.error("用户信息缺失：{}", mxkUserinfo);
            }

        });
        // 更新用户职务字典项

        // 先删除用户职务字典项
        List<SysDictItem> sysDictItems = sysDictItemService.selectItemsByMainId("1964944899916697602");
        List<String> ItemIds = sysDictItems.stream()
                .map(sysDictItem -> sysDictItem.getId()).collect(Collectors.toList());
        sysDictItemMapper.deleteByIds(ItemIds);

        List<SysPosition> sysPositions = sysPositionMapper.selectList(new LambdaQueryWrapper<>());
        List<SysDictItem> items = sysPositions.stream()
                .map(sysPosition -> {
                    SysDictItem sysDictItem = new SysDictItem();
                    sysDictItem.setDictId("1964944899916697602");
                    sysDictItem.setItemText(sysPosition.getName());
                    sysDictItem.setItemValue(String.valueOf(sysPosition.getPostLevel()));
                    sysDictItem.setDescription(sysPosition.getName());
                    sysDictItem.setSortOrder(sysPosition.getPostLevel());
                    return sysDictItem;
                })
                .collect(Collectors.toList());
        sysDictItemMapper.insert(items);

        log.info("同步Maxkey用户信息成功：{}条，失败：{}条", successCount, failCount);
    }
}
